<?php

namespace Models;

require_once __DIR__ . '/../../config/database.php';

use Illuminate\Database\Eloquent\Model as Eloquent;

/**
 * @author Marcelo Rocha <catracacelo@gmail.com> <marcelo@planetascript.com>
 * <website www.planetascript.com>
 */
class Foto extends Eloquent {

    protected $primaryKey = 'foto_id';
    protected $table = 'foto';
    public $timestamps = false;
    protected $fillable = [
        'foto_url', 'foto_pos', 'foto_galeria'
    ];

    public function FotoByGaleria($id) {
        return Foto::where('foto_galeria', '=', $id)->orderBy('foto_pos', 'ASC')->get();
    }


    public function count($id) {
        return Foto::where('foto_galeria', '=', $id)->count();
    }

}
