<?php

require_once __DIR__ . '/../vendor/autoload.php';
$sid = new \Model\Session();
$sid->start();
if (!$sid->check()) {
    header('location:' . \Validacao::getBaseAdmin() . 'login.php');
    exit;
}

function incluir() {
    $data = filter_input_array(INPUT_POST, FILTER_DEFAULT);
    $senha = ['usuario_senha' => Validacao::Hash($data['usuario_senha'])];
    $array = array_merge($data, $senha);
    Models\Usuario::insert($array);
    Filter::redirect("usuario.php?adicionado");
}

function atualizar() {
    $data = filter_input_array(INPUT_POST, FILTER_DEFAULT);
    if ($data['usuario_senha'] != "") {
        $data = ['usuario_senha' => Validacao::Hash($data['usuario_senha'])] + $data;
    } else {
        unset($data['usuario_senha']);
    }
    Models\Usuario::where('usuario_id', '=', $data['usuario_id'])->update($data);
    Filter::redirect("usuario.php?atualizado");
}

function remover() {
    $data = filter_input_array(INPUT_GET, FILTER_DEFAULT);
    Models\Usuario::where('usuario_id', '=', $data['usuario_id'])->delete();
    Filter::redirect("usuario.php?removido");
}

function Json() {
    $data = filter_input_array(INPUT_GET, FILTER_DEFAULT);
    $jason = Models\Usuario::find($data['usuario_id']);
    echo $jason;
}

if (isset($_GET['acao']) && !empty($_GET['acao'])) {
    $acao = $_GET['acao'];
    if (function_exists($acao)) {
        $acao();
    }
}

    