<?php

require_once __DIR__ . '/../vendor/autoload.php';
$sid = new \Model\Session();
$sid->start();
if (!$sid->check()) {
    header('location:' . \Validacao::getBaseAdmin() . 'login.php');
    exit;
}

function incluir() {
    $data = filter_input_array(INPUT_POST, FILTER_DEFAULT);
    $date = ['noticia_data' => Format::InverterData($data['noticia_data'])];
    if ($_FILES['noticia_imagem']['tmp_name'] != '') {
        $img = $_FILES['noticia_imagem']['tmp_name'];
        $filename = Format::Extension($img);
        move_uploaded_file($_FILES['noticia_imagem']['tmp_name'], "../uploads/$filename");
        $data = ['noticia_imagem' => $filename] + $data;
    }
    $array = array_merge($data, $date);
    \Models\Noticia::insert($array);
    Filter::redirect("noticia.php?cadastrado");
}

function atualizar() {
    $data = filter_input_array(INPUT_POST, FILTER_DEFAULT);
    $atualizar = \Models\Noticia::find($data['noticia_id']);
    $date = ['noticia_data' => Format::InverterData($data['noticia_data'])];
    if ($_FILES['noticia_imagem']['tmp_name'] != '') {
        if (file_exists('../uploads/' . $atualizar->noticia_imagem)) {
            @unlink('../uploads/' . $atualizar->noticia_imagem);
        }
        $img = $_FILES['noticia_imagem']['tmp_name'];
        $filename = Format::Extension($img);
        move_uploaded_file($_FILES['noticia_imagem']['tmp_name'], "../uploads/$filename");
        $data = ['noticia_imagem' => $filename] + $data;
    } else {
        unset($data['noticia_imagem']);
    }
    $array = array_merge($data, $date);
    $atualizar->update($array);
    Filter::redirect("noticia.php?atualizado");
}

function remover() {
    $data = filter_input_array(INPUT_GET, FILTER_DEFAULT);
    $remover = \Models\Noticia::find(intval($data['noticia_id']));
    if (file_exists('../uploads/' . $remover->noticia_imagem)) {
        @unlink('../uploads/' . $remover->noticia_imagem);
    }
    $remover->delete();
    Filter::redirect("noticia.php?removido");
}

if (isset($_REQUEST['acao']) && !empty($_REQUEST['acao'])) {
    $acao = $_REQUEST['acao'];
    if (function_exists($acao)) {
        $acao();
    }
}

