<?php
use Models\CategoriaGaleria;
use Models\Galeria;

require_once __DIR__ . '/../vendor/autoload.php';
$sid = new \Model\Session();
$sid->start();
if (!$sid->check()) {
    header('location:' . \Validacao::getBaseAdmin() . 'login.php');
    exit;
}
$galeria_id = intval($_GET['id']);
$galeria = (new Galeria)->edit($galeria_id);
$categorias = (new CategoriaGaleria)->show();
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>ADMIN | Galeria de Fotos</title>
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <link href="bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css"/>
    <link href="plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css"/>
    <link href="plugins/ionicons/css/ionicons.min.css" rel="stylesheet" type="text/css"/>
    <link href="plugins/input-text/style.min.css" rel="stylesheet" type="text/css"/>
    <link href="plugins/bootstrap-datepicker/css/bootstrap-datepicker.min.css" rel="stylesheet" type="text/css"/>
    <link href="plugins/dropzone/dropzone.min.css" rel="stylesheet" type="text/css"/>
    <link href="plugins/sweetalert/dist/sweetalert.css" rel="stylesheet" type="text/css"/>
    <link href="plugins/select2-4.0.2/dist/css/select2.min.css" rel="stylesheet" type="text/css"/>
    <link href="dist/css/AdminLTE.min.css" rel="stylesheet" type="text/css"/>
    <link href="dist/css/skins/_all-skins.min.css" rel="stylesheet" type="text/css"/>
    <link href="dist/css/skins/ui.css" rel="stylesheet" type="text/css"/>
    <link href="plugins/iCheck/all.css" rel="stylesheet" type="text/css"/>
    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="plugins/jQuery/html5shiv.min.js"></script>
    <script src="plugins/jQuery/respond.min.js"></script>
    <![endif]-->
</head>
<body class="skin-blue sidebar-mini">
<div class="wrapper">

    <header class="main-header">
        <?php require_once './topo.php'; ?>
    </header>
    <aside class="main-sidebar">
        <?php require_once './menu.php'; ?>
    </aside>
    <div class="content-wrapper">
        <section class="content-header">
            <h1>Galeria</h1>
            <ol class="breadcrumb">
                <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
                <li class="active">Galeria</li>
            </ol>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-xs-12">
                    <div class="box box-primary">
                        <div class="box-header">
                            <h3 class="box-title"><i class="fa fa-save"></i> Cadastrar informações</h3>
                        </div>
                        <div class="box-body">
                            <form method="post" action="galeria_fn.php?acao=atualizar">
                                <div class="modal-body" id="hoshi">
                                    <div class="form-group">
                                        <select name="categoria_galeria_id" id="categoria_galeria_id"
                                                style="width: 100%">
                                            <?php if (isset($categorias[0])): ?>
                                                <?php foreach ($categorias as $categoria): ?>
                                                    <option
                                                        value="<?= $categoria->id ?>"><?= $categoria->nome ?>
                                                    </option>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                    <label class="text-muted">Destaque</label>
                                    <div class="form-group">
                                        <div class="icheckbox">
                                            <input type="radio" name="status" id="radio1"
                                                   value="1" <?= $galeria->status == 1 ? 'checked' : '' ?> />
                                            <label for="radio1" class="text-muted"> Sim </label>
                                        </div>
                                        <div class="icheckbox">
                                            <input type="radio" name="status" id="radio2"
                                                   value="2" <?= $galeria->status == 2 ? 'checked' : '' ?> />
                                            <label for="radio2" class="text-muted"> Não </label>
                                        </div>
                                    </div>
                                    <span class="input input--hoshi">
                                                <input class="input__field input__field--hoshi" type="text" name="nome"
                                                       required value="<?= $galeria->nome ?>"/>
                                                <input type="hidden" name="id" value="<?= $galeria->id ?>"/>
                                                <label
                                                    class="input__label input__label--hoshi input__label--hoshi-color-1"
                                                    for="nome">
                                                    <span class="input__label-content input__label-content--hoshi">Título</span>
                                                </label>
                                            </span>
                                    <div class=" text-center">
                                        <button type="submit" class="btn btn-primary btn-rounded">Atualizar</button>
                                    </div>
                                </div>
                            </form>
                            <div class="text-center pad">
                                <div id="btn-modal-drop">
                                    <img src="image/upload.png"
                                         style="font-size: 88px;width: 135px;padding: 0px; cursor: pointer">
                                </div>
                            </div>
                            <form method="post" id="form-remove"
                                  action="foto_fn.php?acao=removerFoto&id=<?= $galeria_id ?>">
                                <?php $flag = (isset($galeria->fotos[0])) ? 'show' : 'hide'; ?>
                                <div id="galeria" class="col-sm-12 col-md-12 row" style="border:0px solid red;">
                                    <?php if (isset($galeria->fotos[0])) : ?>
                                        <?php foreach ($galeria->fotos as $f) : ?>
                                            <div class="col-md-2  col-sm-3 col-xs-6" id="li_<?= $f->id ?>">
                                                <input class="hidden" type="checkbox" name="fotos[]"
                                                       value="<?= $f->id ?>" id="check_<?= $f->id ?>"/>
                                                <i class="fa fa-arrows fa-2x move"></i>
                                                <img src="../uploads/galeria/<?= $f->url ?>"
                                                     class="thumbnail tip click-remove" id="<?= $f->id ?>"
                                                     style="width: 100%; height: 184px;" title="marcar para remover">
                                            </div>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </div>
                                <div class="col-xs-12 div-btn-remove">
                                    <p class="text-center">
                                        <button type="button" class="btn btn-danger btn-sel-tudo <?= $flag ?>">
                                            <i class="fa fa-check-circle-o"></i>
                                            Selecionar Tudo
                                        </button>
                                        <button type="button" class="btn btn-danger btn-sel-nada hide">
                                            <i class="fa fa-undo"></i>
                                            Desmarcar Tudo
                                        </button>
                                        <button type="button" class="btn btn-danger" id="btn-submit-remove">
                                            <i class="fa fa-trash-o"></i>
                                            Remover Selecionadas
                                        </button>
                                    </p>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <?php require_once './rodape.php'; ?>
    <div class="modal fade" id="modal-drop">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">ENVIAR FOTOS</h4>
                </div>
                <div class="modal-body">
                    <form id="form-dropzone" class="dropzone" style="margin: 15px !important;border: 1px solid #555;"
                          action="upload.php?id=<?= $galeria_id ?>" enctype="multipart/form-data" method="post">
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class='control-sidebar-bg'></div>

</div>
<script src="plugins/jQuery/jQuery-2.1.4.min.js"></script>
<script src="plugins/jQueryUI/jquery-ui-1.11.2.min.js"></script>
<script src="bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
<script src='plugins/sweetalert/dist/sweetalert.min.js'></script>
<script src="plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js" type="text/javascript"></script>
<script src="plugins/bootstrap-datepicker/locales/bootstrap-datepicker.pt-BR.min.js" type="text/javascript"></script>
<script src="plugins/slimScroll/jquery.slimscroll.min.js" type="text/javascript"></script>
<script src='plugins/fastclick/fastclick.min.js'></script>
<script src='plugins/dropzone/dropzone.min.js'></script>
<script src='plugins/sweetalert/sweetalert.js'></script>
<script src='plugins/select2-4.0.2/dist/js/select2.min.js'></script>
<script src="dist/js/app.min.js" type="text/javascript"></script>
<script src="dist/js/demo.js" type="text/javascript"></script>
<script src='plugins/iCheck/icheck.min.js'></script>
<script type="text/javascript">
    $(".galeriaeditar").addClass('active');
    $('#data').datepicker({
        orientation: "auto bottom",
        language: 'pt-BR'
    });
    $('#categoria_galeria_id').val(<?=$galeria->categoria_galeria_id?>);
    $('.icheckbox').iCheck({
        checkboxClass: 'icheckbox_square',
        radioClass: 'iradio_square',
        increaseArea: '20%' // optional
    });
    $(document).ready(function () {
        $("select").select2({
            placeholder: "Selecione a Categoria"
        });
    });
    function reloadActions() {
        $("#galeria").sortable({
            stop: function (event, ui) {
                var ids = $("#galeria").sortable("toArray");
                var url = 'foto_fn.php?acao=posicao';
                console.log(ids);
                $.post(url, {item: ids}, function (data) {
                    _alertsuccess('Posição atualizada com sucesso!');
                });
            }
        });

        $("#galeria").disableSelection();

        $('#btn-modal-drop').on('click', function () {
            $('#modal-drop').modal('show');
        });
    }

    $(function () {
        Dropzone.autoDiscover = false;
        $(".dropzone").dropzone({
            url: "upload.php?acao=galeria&id=<?= $galeria_id ?>",
            accept: function (file, done) {
                done();
            },
            maxFilesize: 2000, // MB
            complete: function (file) {
                //console.log($('#form-dropzone').html())
                if (this.getUploadingFiles().length === 0 && this.getQueuedFiles().length === 0) {
                    $('.dz-preview').each(function () {
                        $(this).fadeOut(1000);
                    });
                    $('#msg-drop').html('<h1 style="font-size:20px !important" class="text-center"><i class="fa fa-3x fa-thumbs-up"></i>  <br /> Upload Concluído</h1>');
                    setTimeout(function () {
                        $('#msg-drop').html('<h1 style="font-size:20px !important" class="text-center"><i class="fa fa-3x fa-cloud-upload"></i>  <br /> Arraste as fotos para cá ou clique aqui para enviar os arquivos</h1>');
                        /*
                         $('.click-remove').on('click', function () {
                         var id = $(this).attr('id');
                         $('#check_' + id).trigger('click');
                         $('#' + id).toggleClass('btn-danger');
                         });
                         */
                        $('.div-btn-remove').removeClass('hide').show();

                    }, 2000);
                    window.location.reload();
                }

                var f = $.parseJSON(file.xhr.response);
                var div = '';
                div += '    <div class="col-md-3"> ';
                div += '        <input class="hide" type="checkbox" name="fotos[]" value="' + f.id + '" id="check_' + f.id + '"  />';
                div += '        <img src="../uploads/galeria/' + f.url + '" class="thumbnail tip click-remove" id="' + f.id + '" ';
                div += '             style="cursor: pointer;width: 291px; height: 200px;" title="marcar para remover" >';
                div += '    </div>';
                $('#galeria').append(div);
                reloadActions();
            },
            sending: function (file, xhr, formData) {
                formData.append("galeria_id", "<?= $galeria_id ?>");
                if (xhr.readyState === 4) {
                    //console.log(xhr.response)
                }
            },
            totaluploadprogress: function () {
            }
        });
    });
    $('#btn-submit-remove').hide();

    $('#btn-submit-remove').on('click', function () {
        if ($('input:checked').length >= 1) {
            $('#form-remove').submit();
        }
    });

    $('.click-remove').on('click', function () {
        var id = $(this).attr('id');
        $('#check_' + id).trigger('click');
        $('#' + id).toggleClass('btn-danger');

        if ($('input:checked').length >= 1) {
            $('#btn-submit-remove').show();
        } else {
            $('#btn-submit-remove').hide();
        }
    });

    $('.btn-sel-tudo').on('click', function () {
        $('.click-remove').each(function () {
            var id = $(this).attr('id');
            $('#' + id).addClass('btn-danger');
            $('#check_' + id).attr('checked', 'checked');
        });
        $('.btn-sel-tudo').hide();
        $('.btn-sel-nada').removeClass('hide').show();

        if ($('input:checked').length >= 1) {
            $('#btn-submit-remove').show();
        } else {
            $('#btn-submit-remove').hide();
        }
        $('#btn-submit-remove').show();
    });

    $('.btn-sel-nada').on('click', function () {
        $('.click-remove').each(function () {
            var id = $(this).attr('id');
            $('#' + id).removeClass('btn-danger');
            $('#check_' + id).removeAttr('checked');
        });
        $('.btn-sel-tudo').show();
        $('.btn-sel-nada').hide();

        if ($('input:checked').length >= 1) {
            $('#btn-submit-remove').show();
        } else {
            $('#btn-submit-remove').hide();
        }
    });
    $(function () {
        reloadActions();
    });
</script>
</body>
</html>
