<?php

namespace Models;

require_once __DIR__ . '/../../config/database.php';

use Illuminate\Database\Eloquent\Model as Eloquent;

/**
 * @author Marcelo Rocha <catracacelo@gmail.com> <marcelo@planetascript.com>
 * <website www.planetascript.com>
 * 
 * Classe video
 * 
 * 
 */
class Pdf extends Eloquent {

    protected $primaryKey = 'pdf_id';
    protected $table = 'pdf';
    public $timestamps = false;
    protected $fillable = [
        'pdf_nome', 'pdf_arquivo',
    ];

    public function show() {
        return Pdf::orderBy('pdf_id', 'DESC')->get();
    }
    
    public function paginate() {
        return Pdf::orderBy('pdf_id', 'DESC')->paginate(24);
    }
    
    public function limit() {
        return Pdf::orderBy('pdf_id', 'DESC')->take(4)->get();
    }

}
