<?php

namespace Models;

require_once __DIR__ . '/../../config/database.php';

use Illuminate\Database\Eloquent\Model as Eloquent;

/**
 * @author Marcelo Rocha <catracacelo@gmail.com> <marcelo@planetascript.com>
 * <website www.planetascript.com>
 */
class Fotov extends Eloquent {

    protected $primaryKey = 'fotov_id';
    protected $table = 'fotov';
    public $timestamps = false;
    protected $fillable = [
        'fotov_url', 'fotov_pos', 'fotov_viagem'
    ];

    public function FotoByViagem($id) {
        return Fotov::where('fotov_viagem', '=', $id)->orderBy('fotov_pos', 'ASC')->get();
    }


    public function count($id) {
        return Fotov::where('fotov_viagem', '=', $id)->count();
    }

}
