<?php

namespace Models;

require_once __DIR__ . '/../../config/database.php';

use Illuminate\Database\Eloquent\Model as Eloquent;

/**
 * @author Marcelo Rocha <catracacelo@gmail.com> <contato@planetascript.com>
 * <website www.planetascript.com>
 * Classe Artigo
 */
class Artigo extends Eloquent {

    protected $primaryKey = 'artigo_id';
    protected $table = 'artigo';
    public $timestamps = false;
    protected $fillable = [
        'artigo_nome', 'artigo_descricao', 'artigo_data', 'artigo_imagem',
        'artigo_status',
    ];

    public function edit($id) {
        return Artigo::find($id);
    }

    public function show() {
        return Artigo::orderBy('artigo_id', 'DESC')->get();
    }

    public function status() {
        return Artigo::where('artigo_status', '=', 1)->get();
    }
    
    public function paginate() {
        return Artigo::orderBy('artigo_id', 'DESC')->paginate(12);
    }

}
