<?php

namespace Models;

require_once __DIR__ . '/../../config/database.php';

use Illuminate\Database\Eloquent\Model as Eloquent;

/**
 * @author Marcelo Rocha <catracacelo@gmail.com> <marcelo@planetascript.com>
 * <website www.planetascript.com>
 */
class Foton2 extends Eloquent
{

    protected $table = 'noticia2_fotos';
    public $timestamps = false;
    protected $fillable = [
        'file_name', 'pos', 'noticia2_id'
    ];

    public function FotoByNoticia2($id)
    {
        return Foton2::where('noticia2_id', $id)->orderBy('pos', 'ASC')->get();
    }

    public function count($id)
    {
        return Foton2::where('noticia2_id', '=', $id)->count();
    }

}
