<?php


namespace App\Controllers\Site;


use App\Models\Galeria;
use App\Models\GaleriaFoto;

class GaleriaController
{
    public function galeriHome()
    {
        return Galeria::addSelect([
            'foto' => GaleriaFoto::select('url')->whereColumn('galeria_id', 'galerias.id')->orderBy('pos', 'ASC')->limit(1)
        ])->where('status', '=', 1)->take(3)->get();
    }

    public function galerias()
    {
        return Galeria::addSelect([
            'foto' => GaleriaFoto::select('url')->whereColumn('galeria_id', 'galerias.id')->orderBy('pos', 'ASC')->limit(1)
        ])->get();
    }

    public function galeria($id)
    {
        $galeria = Galeria::find($id);
        return $galeria;
    }
}