<?php


namespace App\Controllers\Site;


use App\Models\Frota;
use App\Models\FrotaFoto;

class FrotaController
{
    public function frotaHome()
    {
        return Frota::addSelect([
            'foto' => FrotaFoto::select('url')->whereColumn('frota_id', 'frotas.id')->orderBy('pos', 'ASC')->limit(1)
        ])->orderBy('id', 'DESC')->take(3)->get();
    }

    public function frota($id)
    {
        $frota = Frota::find($id);
        return $frota;
    }

    public function frotas()
    {
        $frotas = Frota::addSelect([
            'foto' => FrotaFoto::select('url')->whereColumn('frota_id','frotas.id')->orderBy('pos','ASC')->limit(1)
        ])->get();
        return $frotas;
    }
}