<?php


namespace App\Controllers\Admin;
require_once __DIR__ . '/../../../config/database.php';

use App\Models\Session;
use App\Models\Usuario;

class UsuarioController
{

    public function Verifica($data)
    {
        $usuario = Usuario::where('email', '=', $data['email'])->first();
        if (password_verify($data['senha'], $usuario->senha)) {
            $sid = new Session();
            $sid->start();
            $sid->init(36000);
            $sid->addNode('start', date('d/m/Y - h:i'));
            $sid->addNode('nome', $usuario->nome);
            $sid->addNode('imagem', $usuario->imagem);
            return true;
        } else {
            return false;
        }
    }

    public function usuarios()
    {
        return Usuario::all();
    }

    public function store($data)
    {
        Usuario::create($data);
    }

    public function edit($data)
    {
        $usuario = Usuario::find($data['usuario_id'])->toJson();
        return $usuario;
    }

    public function update($data)
    {
        $usuario = Usuario::find($data['id']);
        $usuario->update($data);
    }

    public function destroy($data)
    {
        $usuario = Usuario::find($data['usuario_id']);
        $usuario->delete();
    }
}