<?php


namespace App\Controllers\Admin;


use App\Models\Slide;

class SlideController
{

    public function imagens()
    {
        return Slide::orderBy('pos', 'ASC')->get();
    }

    public function store($data)
    {
        Slide::create($data);
    }

    public function edit($id)
    {
        return Slide::find($id);
    }

    public function update($data)
    {
        $slide = Slide::find($data['id']);
        if ($data['imagem'] != '') {
            $this->removerImagem($slide->imagem);
        } else {
            unset($data['imagem']);
        }
        $slide->update($data);
    }

    public function destroy($data)
    {
        $slide = Slide::find($data['id']);
        $this->removerImagem($slide->imagem);
        $slide->delete();
    }

    private function removerImagem($imagem)
    {
        if (file_exists('../uploads/' . $imagem)) {
            @unlink('../uploads/' . $imagem);
        }
    }

    public function posicao($data)
    {
        foreach ($data as $pos => $id) {
            $slide_id = preg_replace('/pos_/', ' ', $id);
            Slide::find($slide_id)
                ->update(['pos' => $pos]);
        }
    }
}