<?php


namespace App\Controllers\Admin;


use App\Models\NoticiaFoto;
use App\Models\Noticia;

class NoticiaController
{

    public function noticias()
    {
        return Noticia::with(['fotos' => function($query){
            $query->orderBy('pos','ASC')->first();
        }])->get();
    }

    public function store($data)
    {
        $noticia = Noticia::create($data);
        return $noticia->id;
    }

    public function edit($id)
    {
        $noticia = Noticia::with('fotos')->find($id);
        return $noticia;
    }
    public function update($data)
    {
        $noticia = Noticia::find($data['id']);
        $noticia->update($data);
    }

    public function destroy($data)
    {
        $noticia = Noticia::find($data['id']);
        foreach ($noticia->fotos as $foto) {
            $this->removerImagem($foto->url);
        }
        $noticia->delete();
    }

    private function removerImagem($imagem)
    {
        if (file_exists('../uploads/noticia/' . $imagem)) {
            @unlink('../uploads/noticia/' . $imagem);
        }
    }
}