<?php


namespace App\Controllers\Admin;


use App\Models\Noticia2;

class Noticia2Controller
{

    public function noticias()
    {
        return Noticia2::with(['fotos' => function ($query) {
            $query->limit(1);
        }])->get();
    }


    public function store($data)
    {
        $noticia = Noticia2::create($data);
        return $noticia->id;
    }

    public function edit($id)
    {
        return Noticia2::find($id);
    }

    public function update($data)
    {
        $noticia = Noticia2::find($data['id']);
        $noticia->update($data);
    }

    public function destroy($data)
    {
        $noticia = Noticia2::find($data['id']);
        foreach ($noticia->fotos as $foto) {
            $this->removerImagem($foto->file_name);
        }
        $noticia->delete();
    }

    private function removerImagem($imagem)
    {
        if (file_exists('../uploads/noticia/' . $imagem)) {
            @unlink('../uploads/noticia/' . $imagem);
        }
    }
}