<?php


namespace App\Controllers\Admin;


use App\Models\FrotaFoto;

class FrotaFotosController
{
    public function destroy($data)
    {
        foreach ($data['fotos'] as $photo_id) {
            $photo = FrotaFoto::find($photo_id);
            $this->removerImagem($photo->url);
            $photo->delete();
        }
    }

    private function removerImagem($imagem)
    {
        if (file_exists('../uploads/frota/' . $imagem)) {
            @unlink('../uploads/frota/' . $imagem);
        }
    }

    public function posicao($data)
    {
        foreach ($data['item'] as $pos => $id) {
            $foto_id = preg_replace('/li_/', ' ', $id);
            FrotaFoto::find($foto_id)->update(['pos' => $pos]);
        }
    }

    public function upload()
    {
        if ($_SERVER['REQUEST_METHOD'] == "POST") {
            $ext = strtolower(substr($_FILES['file']['name'], -4));
            $url = uniqid(time(), true) . $ext;
            if (move_uploaded_file($_FILES['file']['tmp_name'], "../uploads/frota/" . $url)) {
                $frota_id = $_REQUEST['frota_id'];
                $foto = FrotaFoto::create([
                    'url' => $url,
                    'frota_id' => $frota_id,
                ]);
                echo json_encode(array('url' => $foto->url, 'id' => $foto->id));
            }
        }
    }
}