<?php


namespace App\Controllers\Admin;


use App\Models\Frota2Foto;

class Frota2FotosController
{
    public function destroy($data)
    {
        foreach ($data['fotos'] as $photo_id) {
            $photo = Frota2Foto::find($photo_id);
            $this->removerImagem($photo->file_name);
            $photo->delete();
        }
    }

    private function removerImagem($imagem)
    {
        if (file_exists('../uploads/frota/' . $imagem)) {
            @unlink('../uploads/frota/' . $imagem);
        }
    }

    public function posicao($data)
    {
        foreach ($data['item'] as $pos => $id) {
            $foto_id = preg_replace('/li_/', ' ', $id);
            Frota2Foto::find($foto_id)->update(['pos' => $pos]);
        }
    }

    public function upload()
    {
        if ($_SERVER['REQUEST_METHOD'] == "POST") {
            $ext = strtolower(substr($_FILES['file']['name'], -4));
            $file_name = uniqid(time(), true) . $ext;
            if (move_uploaded_file($_FILES['file']['tmp_name'], "../uploads/frota/" . $file_name)) {
                $frota_id = $_REQUEST['frota2_id'];
                $foto = Frota2Foto::create([
                    'file_name' => $file_name,
                    'frota2_id' => $frota_id,
                ]);
                echo json_encode(array('file_name' => $foto->file_name, 'id' => $foto->id));
            }
        }
    }
}