<?php


namespace App\Controllers\Admin;

use App\Models\Frota2;

class Frota2Controller
{
    public function frotas()
    {
        return Frota2::all();
    }

    public function store($data)
    {
        $frota = Frota2::create($data);
        return $frota->id;
    }

    public function edit($id)
    {
        return Frota2::find($id);
    }

    public function update($data)
    {
        Frota2::find($data['id'])->update($data);
    }

    public function destroy($data)
    {
        $frota = Frota2::find($data['id']);
        foreach ($frota->fotos as $foto) {
            $this->removerImagem($foto->file_name);
            $foto->delete();
        }
        $frota->delete();
    }

    private function removerImagem($imagem)
    {
        if (file_exists('../uploads/frota/' . $imagem)) {
            @unlink('../uploads/frota/' . $imagem);
        }
    }
}